package gov.va.vinci.dart.db.impl;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.Narrative;
import gov.va.vinci.dart.db.NarrativeDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class NarrativeDAOImpl extends HibernateDAO implements NarrativeDAO {

	@Override
	public Narrative findById(final int narrativeId) {
		Query q = createQuery("from Narrative where id=:cid");
		q.setParameter("cid", narrativeId);
		return (Narrative)q.getSingleResult();
	}

	@Override
	public void save(Narrative narrative) {
		if (narrative == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(narrative);
	}

}
